<?php

namespace App\Entity;

use App\Entity\EntityTrait\ContactEmailTelTrait;
use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\GeolocEntityTrait;
use App\Entity\EntityTrait\HasCompteEntity;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 * @ORM\Table(name="comptoir")
 */
class Comptoir
{
    use NameSlugContentEntityTrait,
        TimestampableEntity,
        EnablableEntityTrait,
        GeolocEntityTrait,
        ContactEmailTelTrait,
        HasCompteEntity;

    const UPLOAD_DIR = "comptoir";

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(name="id", type="integer")
     * @ORM\GeneratedValue
     */
    protected $id;

    /**
    * @var \Application\Sonata\MediaBundle\Entity\Media
    * @ORM\ManyToOne(targetEntity="App\Application\Sonata\MediaBundle\Entity\Media", cascade={"persist"}, fetch="LAZY")
    * @ORM\JoinColumn(name="media_id", referencedColumnName="id")
    */
    protected $media;

    /**
     * @var Groupe $comptoirGroup
     *
     * @ORM\ManyToOne(targetEntity="Groupe", inversedBy="comptoirs")
     * @ORM\OrderBy({"name": "ASC"})
     */
    private $groupe;

    // *
    //  * @var User
    //  *
    //  * @ORM\ManyToOne(targetEntity="User", inversedBy="cotisations")
    //  * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
     
    // private $user;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return User
     */
    public function getUser(): User
    {
        return $this->user;
    }

    /**
     * @param User $user
     * @return Comptoir
     */
    public function setUser(User $user)
    {
        $this->user = $user;
        return $this;
    }

    /**
    * Get media
    * @return
    */
    public function getMedia()
    {
        return $this->media;
    }

    /**
    * Set media
    * @return $this
    */
    public function setMedia($media)
    {
        $this->media = $media;
        return $this;
    }

    /**
     * @param null|Groupe $groupes
     * @return $this
     */
    public function setGroupe(?Groupe $groupe)
    {
        $this->groupe = $groupe;
        return $this;
    }

    /**
     * @return null|Groupe
     */
    public function getGroupe(): ?Groupe
    {
        return $this->groupe;
    }

    public function __toString(): string
    {
        return (!empty($this->name)?$this->name:'Comptoir');
    }
}
