<?php

namespace App\Controller;

use App\Entity\News;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class NewsController extends AbstractController
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * @Route("/news", name="news")
     */
    public function listeNewsAction()
    {
        return $this->render('news/liste.html.twig', array(
            'news' => $this->em->getRepository(News::class)->findBy(array('enabled' => true), array('createdAt' => 'DESC'))
        ));
    }

    /**
     * @Route("/news/{slug}", name="news_show")
     */
    public function showNewsAction(News $news)
    {
        return $this->render('news/show.html.twig', array(
            'news' => $news
        ));
    }
}
