<?php

namespace App\Controller;

use App\Entity\Faq;
use App\Entity\User;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use Doctrine\ORM\EntityManagerInterface;
use Geocoder\Provider\Nominatim\Nominatim;
use Geocoder\Query\GeocodeQuery;
use Nelmio\ApiDocBundle\Annotation\Model;
use Nelmio\ApiDocBundle\Annotation\Security;
use Swagger\Annotations as SWG;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class IndexController extends AbstractController
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * @Route("/", name="index")
     */
    // public function index(TranslatorInterface $translator)
    public function index(Request $request)
    {
        // Exemple pour la traduction :
        // $translated = $translator->trans('Symfony is great');
        // $translator->transChoice(
        //     'Hurry up %name%! There is one apple left.|There are %count% apples left.',
        //     10,
        //     // no need to include %count% here; Symfony does that for you
        //     array('%name%' => $user->getName())
        // );

        return $this->render('index.html.twig', [
            'news' => array(),
        ]);
    }

    /**
     * @Route("/charte", name="charte")
     */
    public function charteAction()
    {
        return $this->render('charte.html.twig', array(
            // 'user' => $this->getUser()
        ));
    }

    /**
     * @Route("/faq", name="faq")
     */
    public function faqAction()
    {
        return $this->render('faq/liste.html.twig', array(
            'faqs' => $this->em->getRepository(Faq::class)->findBy(array('enabled' => true), array('createdAt' => 'DESC'))
        ));
    }


    /**
     * @Route("/faq/{slug}", name="show_faq")
     */
    public function showFaqAction(Faq $faq)
    {
        return $this->render('faq/show.html.twig', array(
            'faq' => $faq
        ));
    }

    /**
     * @Route("/contact", name="contact")
     */
    public function contactAction()
    {
        return $this->render('contact.html.twig', array(
            // 'user' => $this->getUser()
        ));
    }
}
