<?php

namespace App\Controller;

use App\Entity\Groupeprestataire;
use App\Entity\Prestataire;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class GroupePrestaController extends AbstractController
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * @Route("/groupe/prestataires/{typeslug}/liste", name="groupepresta_liste")
     */
    public function listeGroupePrestaAction($typeslug, Request $request)
    {
        $groupe = $this->em->getRepository(Groupeprestataire::class)->findBy(array('typeslug' => $typeslug, 'enabled' => true));
        if (empty($groupes)) {
            return $this->redirectToRoute('index');
        }

        return $this->render('groupepresta/liste.html.twig', array(
            'groupes' => $groupes
        ));
    }

    /**
     * @Route("/groupe/prestataires/{typeslug}/carte", name="groupepresta_carte")
     */
    public function carteGroupePrestaAction($typeslug, Request $request)
    {
        $groupes = $this->em->getRepository(Groupeprestataire::class)->findBy(array('typeslug' => $typeslug, 'enabled' => true));
        if (empty($groupes)) {
            return $this->redirectToRoute('index');
        }

        return $this->render('groupepresta/carte.html.twig', array(
            'groupes' => $groupes
        ));
    }
}
