<?php

namespace App\Controller;

use App\Entity\TransactionAdherentPrestataire;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use Nelmio\ApiDocBundle\Annotation\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 *
 * Types de transfert : (Les transferts dans la structure sont les flux de billets détenus par les opérateurs.)
 *
 *  - SIEGE             =>     GROUPES LOCAUX           (Transfert du siège au groupe)
 *  - GROUPES LOCAUX    =>     COMPTOIRS                (Transfert du groupe au comptoir)
 *  - COMPTOIRS         =>     GROUPES LOCAUX           (Transfert du comptoir au groupe)
 *  - COMPTOIRS         =>     ADHERENTS                (Diffusion de monnaie papier auprès des adhérents)
 *  - COMPTOIRS         =>     PRESTATAIRES             (Diffusion de monnaie papier auprès des prestataires)
 *  - PRESTATAIRES      =>     COMPTOIRS                (Reconversion)
 *
 *
 * Types de transaction :
 *
 *   - PRESTATAIRES     =>    ADHERENTS         (Virement vers un adherent)
 *   - PRESTATAIRES     =>    PRESTATAIRES      (Virement entre prestataires)
 *   - ADHERENTS        =>    PRESTATAIRES      (Paiement numérique)
 *
 */
class FluxController extends AbstractController
{
    /**
     * @Route("/flux/transaction/adherent/prestataire", name="transactionAdherentPrestataire")
     */
    public function transactionAdherentPrestataireAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $entity = new TransactionAdherentPrestataire();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransactionAdherentPrestataireFormType::class, $entity);
        $form->handleRequest($request);

            $data = $form->getData();
            dump($data);

        if ($form->isSubmitted() && $form->isValid()) {
            //TODO : terminer fonction ;)
            $em->persist($data);
            $em->flush();
        }

        return $this->render('flux/transactionAdherentPrestataire.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
