<?php

namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\Usergroup;
use App\Form\Type\AdhererFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class AdherentController extends AbstractController
{
    protected $em;
    protected $um;

    public function __construct(EntityManagerInterface $em, UserManagerInterface $um)
    {
        $this->em = $em;
        $this->um = $um;
    }

    /**
     * @Route("/adherer", name="adherer")
     */
    public function adhererAction(Request $request)
    {
        $adherent = new Adherent();
        $user = $this->um->createUser();
        $groupe = $this->em->getRepository(Usergroup::class)->findOneByName('Adherent');
        $user->setEnabled(true);
        $user->addGroup($groupe);
        $user->addRole('ROLE_ADHERENT');
        $adherent->setEcompte('0');
        $user->setAdherent($adherent);
        $adherent->setUser($user);
        if (count($adherent->getUser()->getCotisations()) <= 0) {
            $cotisation = new Cotisation();
            $cotisation->setDebut(new \DateTime());
            $cotisation->setFin(new \DateTime('+ 1 year'));
            $adherent->getUser()->addCotisation($cotisation);
        }
        if ($adherent->getGeoloc() == null) {
            $adherent->setGeoloc(new Geoloc());
        }
        $form = $this->createForm(AdhererFormType::class);
        $form->handleRequest($request);


        if ($form->isSubmitted() && $form->isValid()) {
        }

        return $this->render('adherent/adherer.html.twig', array(
            'user' => $this->getUser(),
            'form' => $form->createView()
        ));
    }
}
