<?php

namespace App\Admin;

use App\Entity\User;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType as SChoiceType;
use Symfony\Component\Translation\TranslatorInterface;

class FluxAdmin extends AbstractAdmin
{
    protected $translator;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setTranslator(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->clearExcept('list');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('transfert_or_transaction', 'doctrine_orm_callback', array(
                'label' => "Type",
                'callback' => function ($queryBuilder, $alias, $field, $value) {
                    if (!$value['value']) {
                        return;
                    }
                    $queryBuilder
                        ->where($alias.".parenttype = :type")
                        ->setParameter('type', $value['value']);
                    return true;
                },
                'advanced_filter' => false,
                'show_filter' => true,
                'field_type' => SChoiceType::class,
                'field_options' => array(
                    'choices' => array('Transactions' => 'transaction', 'Transferts' => 'transfert', 'Cotisations' => 'cotisation'),
                    'placeholder' => 'Indifférent',
                    'expanded' => true,
                    'multiple' => false
                )
            ))
            ->add('type', null, array(
                'label' => 'Type plus précis',
                'advanced_filter' => false,
                'show_filter' => true
            ))
            ->add('operateur', null, array(
                'label' => 'Operateur',
                'advanced_filter' => false,
                'show_filter' => true
            ))
        ;
    }

    public function getTemplate($name)
    {
        if ($name == 'list') {
            return 'block/base_list_with_total.html.twig';
        }

        return parent::getTemplate($name);
    }

    public function getTotalLabel()
    {
        return $this->translator->trans('Total :');
    }

    public function getTotal()
    {
        $datagrid = $this->getDatagrid();
        $datagrid->buildPager();

        $query2 = clone $datagrid->getQuery();
        $query2
            ->select('SUM( ' . $query2->getRootAlias() . '.montant) as total')
            ->setFirstResult(null)
            ->setMaxResults(null);


        $result2 = $query2->execute(array(), \Doctrine\ORM\Query::HYDRATE_SINGLE_SCALAR);

        $query = clone $datagrid->getQuery();
        $query
            ->select('SUM( ' . $query->getRootAlias() . '.montant) as total')
            ->andWhere($query->getRootAlias().".parenttype = :type")
            ->setParameter('type', 'transaction')
            ->setFirstResult(null)
            ->setMaxResults(null);


        $result = $query->execute(array(), \Doctrine\ORM\Query::HYDRATE_SINGLE_SCALAR);

        return $result2.' (Transactions: '.$result.')';
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('type', null, array('label' => 'Type'))
            ->addIdentifier('createdAt', null, array('label' => 'Date'))
            ->addIdentifier('operateur', User::class, array('label' => 'Operateur'))
            ->addIdentifier('expediteur', null, array('label' => 'Expediteur'))
            ->addIdentifier('destinataire', null, array('label' => 'Destinataire'))
            ->addIdentifier('montant', null, array('label' => 'Montant'))
            ->addIdentifier('reference', null, array('label' => 'Reference'))
        ;
    }
}
