<?php

namespace App\Admin;

use App\Entity\Prestataire;
use App\Enum\MoyenEnum;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;

class CotisationAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'cotisation';
    protected $baseRoutePattern = 'cotisation';

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('cotisationInfos.annee', null, array('label' => 'Année'))
            ->add('montant', null, array('label' => 'Montant'))
            ->add('cotisationInfos.recu', null, array('label' => 'Recu ?'))
            ->add('operateur.username', null, array('label' => 'Login'))
            ->add('operateur.email', null, array('label' => 'Email'))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $cotisation = $this->getSubject();
        $now = new \DateTime();
        $formMapper
            ->with('Cotisation', ['class' => 'col-md-8'])
                ->add('cotisationInfos.annee', null, array('label' => 'Année', 'data' => $now->format('Y')))
                ->add('montant', null, array('label' => 'Montant'))
                ->add('moyen', ChoiceType::class, array(
                    'required' => true,
                    'choices' => MoyenEnum::getAvailableTypes(),
                    'choice_label' => function ($choice) {
                        return MoyenEnum::getTypeName($choice);
                    },
                ))
                ->add('cotisationInfos.recu', CheckboxType::class, array('label' => 'Reçu'))
            ->end()
            ->with('Date', ['class' => 'col-md-4'])
                ->add('cotisationInfos.debut', DateType::class, array(
                    'label' => 'Date de début',
                    'data' => new \DateTime(),
                    'widget' => 'single_text',
                    'html5' => false,
                    'attr' => ['class' => 'js-datepicker'],
                ))
                ->add('cotisationInfos.fin', DateType::class, array(
                    'label' => 'Date de fin',
                    'data' => new \DateTime('+ 1 year'),
                    'widget' => 'single_text',
                    'html5' => false,
                    'attr' => ['class' => 'js-datepicker'],
                ))
            ->end()
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        // $collection->remove('edit');
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            // ->addIdentifier('user')
            ->addIdentifier('cotisationInfos.annee')
            ->addIdentifier('cotisationInfos.debut')
            ->addIdentifier('cotisationInfos.fin')
            ->addIdentifier('montant')
            ->addIdentifier('moyen')
            ->addIdentifier('createdAt')
        ;
    }
}
