<?php

namespace App\Admin;

use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;

class CotisationAdherentAdmin extends CotisationAdmin
{
    protected $baseRouteName = 'cotisation_adherent';
    protected $baseRoutePattern = 'cotisation_adherent';

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        $query->leftJoin($query->getRootAliases()[0] . '.operateur', 'u')
              ->andWhere('u.adherent IS NOT NULL')
        ;
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
        parent::configureShowFields($showMapper);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        $formMapper
            ->with('Cotisation', ['class' => 'col-md-8'])
                ->add('operateur', null, array(
                    'label' => 'Adhérent',
                    'disabled' => true
                ), array(
                    'admin_code' => 'admin.adherent.gerer'
                ))
            ->end()
        ;
        parent::configureFormFields($formMapper);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureRoutes(RouteCollection $collection)
    {
        parent::configureRoutes($collection);
        // $collection->add('create', );
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper): void
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('operateur.username', null, array('label' => 'Login'))
            ->addIdentifier('operateur.email', null, array('label' => 'Email'));
        parent::configureListFields($listMapper);
    }
}
