<?php

namespace App\Admin;

use App\Entity\Geoloc;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

class ComptoirAdmin extends AbstractAdmin
{
    protected $datagridValues = [
        '_sort_order' => 'ASC',
        '_sort_by' => 'name',
    ];

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $comptoir = $this->getSubject();
        if ($this->isCurrentRoute('create')) {
            $geoloc = new Geoloc();
            $comptoir->setGeoloc($geoloc);
        }
        $formMapper
            ->with('Comptoir', ['class' => 'col-md-8'])
                ->add('groupe', null, array('label' => 'Groupe local'))
                ->add('name', null, array('label' => 'Nom'))
                ->add('email', null, array('label' => 'Email'))
                ->add('tel', null, array('label' => 'Téléphone'))
                ->add('enabled', null, array('label' => 'Activé ?'))
            ->end()
            ->with('Geoloc', ['class' => 'col-md-4'])
                ->add('geoloc.adresse', null, array('label' => 'Adresse'))
                ->add('geoloc.cpostal', null, array('label' => 'Code postal'))
                ->add('geoloc.ville', null, array('label' => 'Ville'))
                ->add('geoloc.lat', null, array('label' => 'Latitude'))
                ->add('geoloc.lon', null, array('label' => 'Longitude'))
            ->end()
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('enabled')
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name')
            ->addIdentifier('email')
            ->addIdentifier('geoloc.adresse')
            ->addIdentifier('tel')
            ->addIdentifier('updatedAt')
        ;
    }
}
