<?php

namespace App\Twig;

use App\Entity\Flux;
use App\Entity\Groupe;
use App\Entity\Rubrique;
use App\Entity\User;
use App\Factory\FormFactory;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Twig\TwigTest;

class FormExtension extends AbstractExtension
{
    public $container;

    public function __construct($container)
    {
        $this->container = $container;
    }

    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction('getTransactionAdherentAdherentForm', array($this, 'getTransactionAdherentAdherentForm')),
            new \Twig_SimpleFunction('getTransactionAdherentPrestataireForm', array($this, 'getTransactionAdherentPrestataireForm')),
            new \Twig_SimpleFunction('getTransactionPrestataireAdherentForm', array($this, 'getTransactionPrestataireAdherentForm')),
            new \Twig_SimpleFunction('getTransactionPrestatairePrestataireForm', array($this, 'getTransactionPrestatairePrestataireForm')),
            new \Twig_SimpleFunction('getTransfertComptoirToXForm', array($this, 'getTransfertComptoirToXForm')),
            new \Twig_SimpleFunction('getTransfertGroupeComptoirForm', array($this, 'getTransfertGroupeComptoirForm')),
            new \Twig_SimpleFunction('getTransfertSiegeGroupeForm', array($this, 'getTransfertSiegeGroupeForm')),
        ];
    }

    public function getTransactionAdherentAdherentForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionAdherentAdherentForm($user);
    }
    public function getTransactionAdherentPrestataireForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionAdherentPrestataireForm($user);
    }
    public function getTransactionPrestataireAdherentForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionPrestataireAdherentForm($user);
    }
    public function getTransactionPrestatairePrestataireForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransactionPrestatairePrestataireForm($user);
    }
    public function getTransfertComptoirToXForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertComptoirToXForm($user);
    }
    public function getTransfertGroupeComptoirForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertGroupeComptoirForm($user);
    }
    public function getTransfertSiegeGroupeForm(User $user)
    {
        return $this->container->get('app.formfactory')->getTransfertSiegeGroupeForm($user);
    }
}
