<?php

namespace App\Form\Type;

use App\Entity\Comptoir;
use App\Entity\Groupe;
use App\Entity\TransfertComptoirPrestataire;
use App\Entity\TransfertGroupeComptoir;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransfertGroupeComptoirFormType extends TransfertFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => $this->security->getUser()->getGroupesgere()->getId(),
                'data_class' => null,
                'entity_class' => Groupe::class,
                'em' => $this->em
            ))
            ->add('destinataire', EntityType::class, array(
                'class' => Comptoir::class,
                'choices' =>  $this->em->getRepository(Comptoir::class)->findBy(array('enabled' => true)),
                'placeholder' => 'Comptoir',
                'required' => true,
                'label' => 'Comptoir :',
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransfertGroupeComptoir::class,
        ));
    }

    public function getParent()
    {
        return TransfertFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransfertGroupeComptoir';
    }
}
