<?php

namespace App\Form\Type;

use App\Entity\Cotisation;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationInfosFormType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CotisationFormType extends FluxFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('moyen', ChoiceType::class, array(
                'required' => true,
                'choices' => MoyenEnum::getAvailableTypes(),
                'choice_label' => function ($choice) {
                    return MoyenEnum::getTypeName($choice);
                },
            ))
            ->add('montant', HiddenType::class, array(
                'data' => $this->getParameter('api_user'),
            ))
            ->add('type', HiddenType::class, array(
                'data' => 'cotisation',
                'data_class' => null
            ));
            // ->add('cotisationInfos', CotisationInfosFormType::class, array(
            //     'label' => 'Infos'
            // ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Cotisation::class,
            'cascade_validation' => true
        ));
    }


    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formCotisation';
    }
}
