<?php

namespace App\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class ContactFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nom', TextType::class, array(
                'label' => 'Votre nom :',
                'required' => true
            ))
            ->add('email', EmailType::class, array(
                'label' => 'Votre email :',
                'required' => true
            ))
            ->add('message', TextType::class, array(
                'label' => 'Votre message :',
                'required' => true
            ))
            ->add('save', SubmitType::class, ['label' => "Envoyer"])
        ;
    }

    public function getBlockPrefix()
    {
        return 'formContact';
    }
}
