<?php

namespace App\Form\Type;

use App\Entity\Cotisation;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationInfosFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class AddCotisationFormType extends AbstractType
{
    protected $em;
    protected $security;

    public function __construct(EntityManagerInterface $em, Security $security)
    {
        $this->em = $em;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $now = new \DateTime();
        $flux = $options['data'];
        if (empty($this->security) || empty($this->security->getUser()) || empty($this->security->getUser()->getId()) || empty($flux) || empty($flux->getExpediteur())) {
            throw new \Exception("[FLUX] Opération impossible ! Pas d'utilisateur connecté !");
        }
        $maxvalue = $flux->getExpediteur()->getCompte();
        $builder
            ->add('type', HiddenType::class, array(
                'data' => 'cotisation',
                'data_class' => null
            ))
            ->add('operateur', HiddenType::class, array(
                'data' => $this->security->getUser()->getId(),
                'data_class' => null,
                'entity_class' => User::class,
                'em' => $this->em
            ))
            ->add('reference', HiddenType::class, array(
                'label' => 'Reference :',
                'required' => true,
                'data' => 'Cotisation '.$now->format('Y')
            ))
            ->add('montant', MoneyType::class, array(
                'label' => 'Montant :',
                'required' => true
            ))
            ->add('moyen', ChoiceType::class, array(
                'required' => true,
                'choices' => MoyenEnum::getAvailableTypes(),
                'choice_label' => function ($choice) {
                    return MoyenEnum::getTypeName($choice);
                },
            ))
            ;
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Cotisation::class,
            'cascade_validation' => true
        ));
    }


    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formCotisation';
    }
}
