<?php

namespace App\Form\Type;

use App\Entity\User;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UserFormType extends AbstractType
{
    protected $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('email', EmailType::class, array(
                'label' => 'Courriel',
                'required' => true,
                'translation_domain' => 'FOSUserBundle'
            ))
            ->add('firstname', TextType::class, array(
                'label' => 'Prénom',
                'required' => true,
            ))
            ->add('lastname', TextType::class, array(
                'label' => 'Nom',
                'required' => true,
            ))
            ->add('phone', TextType::class, array(
                'label' => 'Téléphone fixe :',
                'required' => false
            ))
            ->add('mobile', TextType::class, array(
                'label' => 'Téléphone mobile :',
                'required' => false
            ))
            ->add('enabled', null, array(
                'label' => 'Activé ?'
            ))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => User::class,
            'cascade_validation' => true
        ));
    }

    public function getBlockPrefix()
    {
        return 'user_form';
    }
}
