<?php

namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\Prestataire;
use App\Entity\TransactionPrestataireAdherent;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransactionPrestataireAdherentFormType extends TransactionFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => $this->session->get('_prestagere')->getId(),
                'data_class' => null,
                'entity_class' => Prestataire::class,
                'em' => $this->em
            ))
            ->add('destinataire', EntityType::class, array(
                'class' => Adherent::class,
                'choices' =>  $this->em->getRepository(Adherent::class)->findOrderByName(),
                'placeholder' => 'Adherent',
                'required' => true,
                'label' => 'Adherent :',
            ))
            ->add('destinataireType', HiddenType::class, array(
                'data' => 'adherent',
                'mapped' => false
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransactionPrestataireAdherent::class,
        ));
    }

    public function getParent()
    {
        return TransactionFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransactionPrestataireAdherent';
    }
}
