<?php

namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\Groupe;
use App\Enum\MoyenEnum;
use App\Form\Type\GeolocFormType;
use App\Form\Type\RegistrationFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class AdhererFormType extends AbstractType
{
    protected $container;
    protected $em;
    protected $security;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em, Security $security)
    {
        $this->container = $container;
        $this->em = $em;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $adherent = $options['data'];
        $builder
            ->add('user', RegistrationFormType::class, array(
                'label' => false,
                'required' => true
            ))
            ->add('groupe', ChoiceType::class, array(
                'required' => true,
                'label' => 'Groupe local',
                'choices' => $this->container->get('doctrine')->getRepository(Groupe::class)->findAll(),
                'choice_label' => 'name',
                'placeholder' => 'Choisir un groupe',
            ))
            ->add('geoloc', GeolocFormType::class, array(
                'label' => false,
                'required' => true,
                'with_geoloc' => false,
                'with_latlon' => false
            ))
            ->add('cotisation', AddCotisationFormType::class, array(
                'label' => false,
                'required' => true,
                'mapped' => false,
                'data_class' => null
            ))
            ->add('save', SubmitType::class, ['label' => "Payer en CB"]);
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Adherent::class,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formAdherer';
    }
}
