<?php

namespace App\Form\Type;

use App\Entity\Cotisation;
use App\Entity\GlobalParameter;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationInfosFormType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Validator\Constraints\NotBlank;

class AddCotisationFormType extends AbstractType
{
    protected $em;
    protected $security;

    public function __construct(EntityManagerInterface $em, Security $security)
    {
        $this->em = $em;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $now = new \DateTime();
        $builder
            ->add('reference', HiddenType::class, array(
                'label' => 'Reference :',
                'required' => true,
                'data' => 'Adhésion '.$now->format('d/m/Y')
            ))
            ->add('montant', IntegerType::class, array(
                'data' => intval($this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::COTISATION_ADHERENT)),
                'constraints' => [
                    new NotBlank()
                ],
            ))
            ->add('moyen', HiddenType::class, array(
                'data' => MoyenEnum::MOYEN_CB,
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Cotisation::class,
            'cascade_validation' => true
        ));
    }

    public function getBlockPrefix()
    {
        return 'formAddCotisation';
    }
}
