<?php

namespace App\Form\Type;

use App\Entity\Prestataire;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AchatMonnaiePrestataireFormType extends AchatMonnaieFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if (empty($this->security) || empty($this->security->getUser())) {
            throw new \Exception("[FORM ACHAT MONNAIE PRESTATAIRE] Opération impossible !");
        }
        $builder
            -> add('destinataire', HiddenType::class, array(
              'data' => $this->session->get('_prestagere')->getId(),
              'data_class' => null,
              'entity_class' => Prestataire::class,
              'em' => $this->em
            ))
            ->add('reference', HiddenType::class, array(
                'data' => 'Achat monnaie en CB Prestataire'
            ))
            ->add('save', SubmitType::class, ['label' => "Payer en CB"])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => AchatMonnaiePrestataire::class,
        ));
    }

    public function getParent()
    {
        return AchatMonnaieFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formAchatMonnaiePrestataire';
    }
}
