<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Vente => (Diffusion de monnaie papier auprès des adhérents)
 *
 * Types de vente :
 *
 *   - COMPTOIR     =>    ADHERENTS         (Vente à un adherent)
 *   - COMPTOIR     =>    PRESTATAIRES      (Vente à un prestataire)
 *
 * @ORM\Entity
 */
abstract class Vente extends Flux
{
    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_VENTE;
    }

    public function operate($em)
    {
        $compteExp = $this->getExpediteur()->getCompte() - $this->getMontant();
        if ($compteExp < 0) {
            throw new \Exception("[FLUX] Vente impossible ! Montant supérieur au solde du comptoir !");
        } else {
            $this->getExpediteur()->removeCompte($this->getMontant());
            $this->getExpediteur()->setUpdatedAt(new \DateTime());
            $this->getExpediteur()->getGroupe()->getSiege()->addCompteNantie($this->getMontant());

            return [$this->getExpediteur(), $this->getExpediteur()->getGroupe()->getSiege()];
        }
        return [];
    }
}
