<?php

namespace App\Entity;

use App\Entity\EntityTrait\HasCompteEntity;
use App\Entity\EntityTrait\HasEcompteEntity;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity(repositoryClass="App\Repository\SiegeRepository")
 * @ORM\Table(name="siege")
 */
class Siege
{
    use NameSlugContentEntityTrait,
        HasCompteEntity,
        HasEcompteEntity;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var ArrayCollection|Groupe[]
     * @ORM\OneToMany(targetEntity="Groupe", mappedBy="siege")
     */
    private $groupes;

    /**
     * @var int
     *
     * @ORM\Column(name="compte_nantie", type="decimal", precision=12, scale=2)
     */
    private $compteNantie = 0;

    public function __construct()
    {
        $this->groupes = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getCompteNantie(): float
    {
        return $this->compteNantie;
    }

    /**
     * @param int $compteNantie
     * @return $this
     */
    public function setCompteNantie(float $compteNantie)
    {
        $this->compteNantie = $compteNantie;
        return $this;
    }

    /**
     * @param int $compteNantie
     * @return $this
     */
    public function addCompteNantie(float $compteNantie)
    {
        $this->compteNantie += $compteNantie;
        return $this;
    }

    /**
     * @param int $compteNantie
     * @return $this
     */
    public function removeCompteNantie(float $compteNantie)
    {
        $this->compteNantie -= $compteNantie;
        return $this;
    }

    /**
     * @return Groupe[]|ArrayCollection
     */
    public function getGroupes()
    {
        return $this->groupes;
    }

    /**
     * @param Groupe $groupe
     * @return $this
     */
    public function addGroupe(Groupe $groupe)
    {
        if (!$this->groupes->contains($groupe)) {
            $this->groupes[] = $groupe;
            $groupe->setSiege($this);
        }
        return $this;
    }

    /**
     * @param Groupe $groupe
     * @return $this
     */
    public function removeGroupe(Groupe $groupe)
    {
        if ($this->groupes->contains($groupe)) {
            $this->groupes->removeElement($groupe);
            $groupe->setSiege(null);
        }
        return $this;
    }

    public function __toString(): string
    {
        return 'SIEGE';
    }
}
