<?php

namespace App\Entity;

use App\Entity\Comptoir;
use App\Entity\EntityTrait\ContactEmailTelTrait;
use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * ApiResource(
 *     attributes={"security"="is_granted('ROLE_ADMIN_COMPTOIR_GERER_VIEW')"},
 *     collectionOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_COMPTOIR_GERER_LIST')"},
 *         "post"={"security"="is_granted('ROLE_ADMIN_COMPTOIR_GERER_EDIT')"}
 *     },
 *     itemOperations={
 *         "get"={"security"="is_granted('ROLE_ADMIN_COMPTOIR_GERER_VIEW')"},
 *         "put"={"security"="is_granted('ROLE_ADMIN_COMPTOIR_GERER_EDIT')"},
 *     },
 *     normalizationContext={"groups"={"read"}},
 *     denormalizationContext={"groups"={"write"}}
 * )
 * @ORM\Entity
 * @ORM\Table(name="contact_comptoir")
 */
class ContactComptoir
{
    use NameSlugContentEntityTrait,
        TimestampableEntity,
        EnablableEntityTrait,
        ContactEmailTelTrait;

    /**
     * @var Comptoir
     *
     * @ORM\ManyToOne(targetEntity="Comptoir", cascade={"persist"}, inversedBy="contacts")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id", nullable=false)
     */
    private $comptoir;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
    * Get comptoir
    * @return
    */
    public function getComptoir(): Comptoir
    {
        return $this->comptoir;
    }
    
    /**
    * Set comptoir
    * @return $this
    */
    public function setComptoir($comptoir): self
    {
        $this->comptoir = $comptoir;
        return $this;
    }
}
