<?php

namespace App\Entity;

use App\Entity\Prestataire;
use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSACTION
 *  - Achat de monnaie en CB par un Prestataire.
 *
 * @ORM\Entity
 */
class AchatMonnaiePrestataire extends AchatMonnaie
{
    /**
     * @ORM\ManyToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_dest_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'achat_monnaie_prestataire';
    }
}
