<?php

namespace App\Entity;

use App\Entity\Siege;
use Doctrine\ORM\Mapping as ORM;

/**
 * Achat de monnaie en CB par un Adhérent ou Prestataire
 *
 * @ORM\Entity
 */
class AchatMonnaie extends Flux
{
    /**
     * @ORM\ManyToOne(targetEntity="Siege")
     * @ORM\JoinColumn(name="siege_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    public function operate($em)
    {
        // Increment Ecompte of Siege
        $this->getExpediteur()->addEcompte($this->getMontant());
        $this->getDestinataire()->addEcompte($this->getMontant());

        return [$this->getExpediteur(), $this->getDestinataire()];
    }

    public function getUsersToNotify()
    {
        return ['siege'];
    }

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_ACHAT;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'achat_monnaie';
    }

}
