<?php

namespace App\Admin;

use App\Entity\User;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Administration des documents
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class DocumentAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'document';
    protected $baseRoutePattern = 'document';
    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $document = $this->getSubject();
        $formMapper
            ->add('user', HiddenType::class, array(
                'data' => $this->getConfigurationPool()->getContainer()->get('security.token_storage')->getToken()->getUser()->getId(),
                'data_class' => null,
                'entity_class' => User::class,
                'em' => $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager()
            ))
            ->add('media', MediaType::class, array(
                'provider' => 'sonata.media.provider.file',
                'context' => 'document',
                'label' => 'Document'
            ))
            ->add('name', TextType::class, array(
                'label' => 'Titre :'
            ))
            ->add('content', CKEditorType::class, array(
                'label' => 'Texte',
                'required' => false,
            ))
            ->add('enabled', CheckboxType::class, array(
                'label' => 'Activé ?',
                'required' => false,
                'label_attr' => array('class' => 'checkbox-inline')
            ))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array('label' => 'Titre'))
            ->addIdentifier('content', 'html', array('truncate' => array('length' => 80), 'label' => 'Description'))
            ->addIdentifier('media', null, array('label' => 'Fichier'))
            ->add('enabled', null, array(
                'label' => 'Activé',
                'editable' => true
            ))
        ;
    }
}
