<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class ApplicationAvailabilityFunctionalTest extends WebTestCase
{
    /**
     * @dataProvider urlProvider
     */
    public function testPageIsSuccessful($url)
    {
        $client = static::createClient([]);
        $client->request('GET', $url);

        $this->assertTrue($client->getResponse()->isSuccessful());
    }

    public function urlProvider()
    {
        yield ['/'];
        yield ['/adherer'];
        yield ['/news'];
        yield ['/faq'];
        yield ['/contact'];
        yield ['/login'];
        yield ['/prestataires/liste'];
        yield ['/prestataires/carte'];
        yield ['/prestataires/rubriques'];
        yield ['/partenaires/liste'];
        yield ['/comptoirs/liste'];
        yield ['/comptoirs/carte'];
        yield ['/groupe/prestataires/amap/carte'];
        yield ['/groupe/prestataires/marche/carte'];
        yield ['/resetting/request'];
    }

    /**
     * @dataProvider adminUrlProvider
     */
    public function testADMINPageIsSuccessful($url)
    {
        $client = static::createClient([], [
            'PHP_AUTH_USER' => 'julien.jorry@gmail.com',
            'PHP_AUTH_PW'   => 'test',
        ]);
        $client->request('GET', $url);

        $this->assertTrue($client->getResponse()->isSuccessful());
    }

    public function adminUrlProvider()
    {
        yield ['/'];
        yield ['/admin/dashboard'];
        yield ['/admin/app/user/list'];
        yield ['/admin/app/user/create'];
        yield ['/admin/app/usergroup/list'];
        yield ['/admin/adherent/list'];
        yield ['/admin/adherent/create'];
        yield ['/admin/cotisation_adherent/list'];
        yield ['/admin/prestataire/list'];
        yield ['/admin/prestataire/create'];
        yield ['/admin/cotisation_prestataire/list'];
        yield ['/admin/cotisation_prestataire/create'];
        yield ['/admin/prestataire/19/edit'];
        yield ['/admin/app/user/51/edit'];
        yield ['/admin/adherent/1/edit'];
        yield ['/admin/app/user/2/edit'];
        yield ['/admin/app/groupeprestataire/list'];
        yield ['/admin/app/groupeprestataire/create'];
        yield ['/admin/app/groupe/list'];
        yield ['/admin/app/groupe/create'];
        yield ['/admin/app/comptoir/list'];
        yield ['/admin/app/comptoir/create'];
        yield ['/admin/app/news/list'];
        yield ['/admin/app/news/create'];
        yield ['/admin/app/document/list'];
        yield ['/admin/app/document/create'];
        yield ['/admin/app/page/list'];
        yield ['/admin/app/page/create'];
        yield ['/admin/app/rubrique/list'];
        yield ['/admin/app/rubrique/create'];
        yield ['/admin/app/faq/list'];
        yield ['/admin/app/faq/create'];
        yield ['/admin/translations/list'];
        yield ['/admin/app/flux/list'];
        yield ['/admin/cotisation/list'];
        yield ['/admin/cotisation/create'];
        yield ['/admin/app/transfert/list'];
        yield ['/admin/app/transaction/list'];
        yield ['/admin/app/transfertprestatairesiege/list'];
        yield ['/admin/sonata/menu/list'];
        yield ['/admin/sonata/menu/create'];
    }
}
