<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Serializer;

use Symfony\Component\Serializer\Normalizer\NormalizerInterface;
use Symfony\Component\Serializer\SerializerAwareInterface;
use Symfony\Component\Serializer\SerializerInterface;
use Sonata\MediaBundle\Provider\Pool;
use App\Entity\Prestataire;

/**
 * This class allows to expose the media of a Prestataire in ApiPlatform
 * (because it's not possible with a Media from SonataMediaBundle)
 */
final class ApiNormalizer implements NormalizerInterface, SerializerAwareInterface
{
    private $decorated;
    private $pool;

    public function __construct(NormalizerInterface $decorated, Pool $pool)
    {
        $this->decorated = $decorated;
        $this->pool = $pool;
    }

    public function supportsNormalization($data, $format = null)
    {
        return $this->decorated->supportsNormalization($data, $format);
    }

    public function normalize($object, $format = null, array $context = [])
    {
        $data = $this->decorated->normalize($object, $format, $context);

        // In the case of normalizing a Prestataire...
        if (! $object instanceof Prestataire) {
            return $data;
        }

        // ... we retrieve its associated Sonata Media (from the Sonata Media's provider, from the providers pool)
        if (is_array($data) && $media = $object->getMedia()) {
            if ($provider = $this->pool->getProvider($media->getProviderName())) {
                $data['media'] = $provider->getHelperProperties($media, 'reference');
            }
        }

        return $data;
    }

    public function setSerializer(SerializerInterface $serializer)
    {
        if($this->decorated instanceof SerializerAwareInterface) {
            $this->decorated->setSerializer($serializer);
        }
    }
}
