<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Repository;

use App\Entity\GlobalParameter;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Common\Persistence\ManagerRegistry;

/**
 * @method GlobalParameter|null find($id, $lockMode = null, $lockVersion = null)
 * @method GlobalParameter|null findOneBy(array $criteria, array $orderBy = null)
 * @method GlobalParameter[]    findAll()
 * @method GlobalParameter[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class GlobalParameterRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, GlobalParameter::class);
    }

    public function findAllByName()
    {
        $results = $this->createQueryBuilder('g')
            ->getQuery()
            ->getArrayResult()
        ;
        $assocArray = array_reduce($results, function ($result, $item) {
            $item = (array) $item;
            $key = $item['name'];
            $value = $item['value'];
            // @TODO : mettre le prefixe 'KOH_' en parametre (conf yaml)
            $result['KOH_'.$key] = $value;

            return $result;
        }, array());

        return $assocArray;
    }

    public function val($name)
    {
        $global = $this->createQueryBuilder('g')
            ->andWhere('g.name = :name')
            ->setParameter('name', $name)
            ->getQuery()
            ->getOneOrNullResult()
        ;

        return ($global ? $global->getValue() : '');
    }
}
