<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Cotisation;
use App\Entity\GlobalParameter;
use App\Enum\MoyenEnum;
use App\Form\Type\CotisationInfosFormType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CotisationFormType extends FluxFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('montant', MoneyType::class, array(
                'label' => 'Montant',
                'data' => floatval($this->em->getRepository(GlobalParameter::class)->val(GlobalParameter::COTISATION_ADHERENT))
            ))
            ->add('moyen', ChoiceType::class, array(
                'required' => true,
                'choices' => MoyenEnum::getAvailableTypes(),
                'choice_label' => function ($choice) {
                    return MoyenEnum::getTypeName($choice);
                },
            ))
            ->add('recu', CheckboxType::class, array(
                'label' => 'Reçu'
            ))
            ->add('cotisationInfos', CotisationInfosFormType::class, array(
                'label' => 'Infos'
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Cotisation::class,
            'cascade_validation' => true
        ));
    }


    // public function getParent()
    // {
    //     return FluxFormType::class;
    // }

    public function getBlockPrefix()
    {
        return 'formCotisation';
    }
}
