<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Enum;

abstract class MoyenEnum
{
    const MOYEN_CB          = "cb";
    const MOYEN_ESPECE      = "espece";
    const MOYEN_CHEQUE      = "cheque";
    const MOYEN_VIREMENT    = "virement";
    const MOYEN_TRANSFERT   = "transfert";
    const MOYEN_HELLOASSO   = "helloasso";
    const MOYEN_MLC         = "mlc";
    const MOYEN_AUTRE       = "autre";
    const MOYEN_VENTE       = "vente";
    const MOYEN_RETRAIT     = "retrait";


    /** @var array user friendly named type */
    protected static $typeName = [
        self::MOYEN_CB          => 'Carte bancaire',
        self::MOYEN_ESPECE      => 'Espèce',
        self::MOYEN_CHEQUE      => 'Chèque',
        self::MOYEN_VIREMENT    => 'Virement',
        self::MOYEN_TRANSFERT   => 'Transfert',
        self::MOYEN_HELLOASSO   => 'HelloAsso',
        self::MOYEN_MLC         => 'MLC',
        self::MOYEN_AUTRE       => 'Autre',
        self::MOYEN_VENTE       => 'Vente',
        self::MOYEN_RETRAIT     => 'Retrait',
    ];

    /**
     * @param  string $typeShortName
     * @return string
     */
    public static function getTypeName($typeShortName)
    {
        if (!isset(static::$typeName[$typeShortName])) {
            return "Unknown type ($typeShortName)";
        }

        return static::$typeName[$typeShortName];
    }

    /**
     * @return array<string>
     */
    public static function getAvailableTypes()
    {
        return [
            self::MOYEN_CB,
            self::MOYEN_ESPECE,
            self::MOYEN_CHEQUE,
            self::MOYEN_VIREMENT,
            self::MOYEN_TRANSFERT,
            self::MOYEN_HELLOASSO,
            self::MOYEN_MLC,
            self::MOYEN_AUTRE,
            self::MOYEN_VENTE,
            self::MOYEN_RETRAIT
        ];
    }
}
