<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Dto\MapInput;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Annotation\ApiResource;
use App\Controller\MapController;
use App\Entity\EntityTrait\GeolocEntityTrait;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *     collectionOperations={
 *         "get",
 *         "post"
 *     },
 *     itemOperations={
 *         "get",
 *         "put",
 *         "delete",
 *     },
 *     collectionOperations={
 *         "get",
 *         "post",
 *         "get_all_poi"={
 *             "controller"=MapController::class,
 *             "method"="GET",
 *             "input"=false,
 *             "output"=Map::class,
 *             "path"="/public/poi/all",
 *             "read"=false,
 *             "swagger_context" = {
 *                 "parameters" = {
 *                      {
 *                          "name" = "geoloc",
 *                          "in" = "query",
 *                          "description" = "[Latitude, Longitude], exemple : [45.123,4.023]",
 *                          "required" = false,
 *                          "type" : "string",
 *                      },
 *                      {
 *                          "name" = "distance",
 *                          "in" = "query",
 *                          "description" = "Distance in kilometers",
 *                          "required" = false,
 *                          "type" : "string"
 *                      }
 *                  }
 *             },
 *             "security"="is_granted('ROLE_ADMIN_PRESTATAIRE_GERER_LIST') or is_granted('ROLE_API')"},
 *     },
 * )
 */
class Map
{
    /**
     * @var string|null
     *
     * @ORM\Column(length=150)
     * @Groups({"read", "write"})
     */
    protected $name;

    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"read", "write"})
     */
    private $content;

    /**
     * @var null|string
     *
     * @ORM\Column(name="web", type="string", length=255, nullable=true)
     * @Groups({"read", "write"})
     */
    private $web;
    
    /**
     * @var null|string
     *
     * @ORM\Column(name="link", type="string", length=255, nullable=true)
     * @Groups({"read", "write"})
     */
    private $link;

    /**
     * @var null|string
     *
     * @ORM\Column(name="hours", type="string", length=255, nullable=true)
     * @Groups({"read", "write"})
     */
    private $hours;

    /**
     * @var null|string
     *
     * @ORM\Column(name="icon", type="string", length=255, nullable=true)
     * @Groups({"read", "write"})
     */
    private $icon;

    /**
     * @var Rubrique[]
     * @ORM\OneToMany(targetEntity="Rubrique")
     * @Groups({"read", "write"})
     */
    private $rubriques;

    /**
     * @var Geoloc[]
     * @ORM\OneToMany(targetEntity="Geoloc")
     * @Groups({"read", "write"})
     */
    private $geolocs;

    /**
    * Get name
    * @return
    */
    public function getName()
    {
        return $this->name;
    }

    /**
    * Get content
    * @return
    */
    public function getContent()
    {
        return $this->content;
    }
    
    /**
    * Get web
    * @return
    */
    public function getWeb()
    {
        return $this->web;
    }

    /**
    * Get link
    * @return
    */
    public function getLink()
    {
        return $this->link;
    }

    /**
    * Get hours
    * @return
    */
    public function getHours()
    {
        return $this->hours;
    }

    /**
    * Get icon
    * @return
    */
    public function getIcon()
    {
        return $this->icon;
    }
    
    /**
    * Get rubriques
    * @return
    */
    public function getRubriques(): ?Rubrique
    {
        return $this->rubriques;
    }
    
    /**
    * Get geolocs
    * @return
    */
    public function getGeolocs(): ?Geoloc
    {
        return $this->geolocs;
    }
}
