<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity\EntityTrait;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation\Groups;

trait HasEcompteEntity
{
    /**
     * Compte de MLC numérique
     * @var int
     *
     * @ORM\Column(name="ecompte", type="decimal", precision=12, scale=2, options={"default" : 0})
     * @Groups({"read"})
     */
    private $ecompte = 0;

    /**
     * @return int
     */
    public function getEcompte(): float
    {
        return $this->ecompte;
    }

    /**
     * @param int $ecompte
     * @return $this
     */
    public function setEcompte(float $ecompte)
    {
        $this->ecompte = $ecompte;
        return $this;
    }

    /**
     * Incremente le ecompte
     * @param int $ecompte
     * @return $this
     */
    public function addEcompte(float $ecompte)
    {
        $this->ecompte += $ecompte;
        return $this;
    }

    /**
     * Décremente le ecompte
     * @param int $ecompte
     * @return $this
     */
    public function removeEcompte(float $ecompte)
    {
        $this->ecompte -= $ecompte;
        return $this;
    }
}
