<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity\EntityTrait;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation\Groups;

trait HasCompteEntity
{
    /**
     * Compte de billets
     * @var int
     *
     * @ORM\Column(name="compte", type="decimal", precision=12, scale=2)
     * @Groups({"read"})
     */
    private $compte = 0;

    /**
     * @return int
     */
    public function getCompte(): float
    {
        return $this->compte;
    }

    /**
     * @param int $compte
     * @return $this
     */
    public function setCompte(float $compte)
    {
        $this->compte = $compte;
        return $this;
    }

    /**
     * Incremente le compte
     * @param int $compte
     * @return $this
     */
    public function addCompte(float $compte)
    {
        $this->compte += $compte;
        return $this;
    }

    /**
     * Décremente le compte
     * @param int $compte
     * @return $this
     */
    public function removeCompte(float $compte)
    {
        $this->compte -= $compte;
        return $this;
    }
}
