<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Entity\GlobalParameter;
use App\Entity\Prestataire;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * COMMISSION
 *  - PRESTATAIRES      =>     PRESTATAIRE MLC                (Commission de Reconversion)
 *
 * @ORM\Entity()
 */
class CommissionPrestataireMLC extends Flux
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_dest_id", referencedColumnName="id")
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_COMMISSION;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'reconversion_prestataire';
    }

    public function operate($em)
    {
        return [];
    }

    public function getUsersToNotify()
    {
        return [];
    }
}
