<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller;

use App\Entity\News;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class NewsController extends FrontController
{
    protected $em;
    private $paginator;

    public function __construct(EntityManagerInterface $em, PaginatorInterface $paginator)
    {
        $this->em = $em;
        $this->paginator = $paginator;
    }

    /**
     * @Route("/news", name="news")
     */
    public function listeNewsAction(Request $request)
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        $pagination = $this->paginator->paginate(
            $this->em->getRepository(News::class)->findLatest(),
            $request->query->getInt('page', 1),
            5
        );
        return $this->render('news/liste.html.twig', array(
            'news' => $pagination,
        ));
    }

    /**
     * @Route("/news/{slug}", name="show_news")
     */
    public function showNewsAction(News $news)
    {
        if (!$this->isFrontActivated()) {
            return $this->redirectToRoute('index');
        }
        return $this->render('news/show.html.twig', array(
            'news' => $news
        ));
    }
}
