<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use App\Application\Sonata\UserBundle\Admin\UserAdmin as SonataUserAdmin;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

/**
 * Administration des utilisateurs
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class UserAdmin extends SonataUserAdmin
{
    protected $baseRouteName = 'user';
    protected $baseRoutePattern = 'user';

    protected $datagridValues = [
        // reverse order (default = 'ASC')
        '_sort_order' => 'DESC',
        // name of the ordered field (default = the model's id field, if any)
        '_sort_by' => 'updatedAt',
        // '_page' => 1,
        // '_per_page' => 32
    ];

    public function configure()
    {
        parent::configure();
        // $this->classnameLabel = "Utilisateurs";
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        parent::configureFormFields($formMapper);

        $user = $this->getSubject();
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper): void
    {
        parent::configureListFields($listMapper);
        unset($this->listModes['mosaic']);

        if ($this->isGranted('ROLE_ALLOWED_TO_SWITCH')) {
            $listMapper
                ->addIdentifier('impersonating', 'string', ['template' => '@SonataUser/Admin/Field/impersonating.html.twig'])
            ;
        }
        // $listMapper
            // ->addIdentifier('username', null, array('label' => 'Username'))
            // ->addIdentifier('email', null, array('label' => 'Email'));
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        if ($this->isChild()) {
            $collection->remove('delete');
            return;
        }

        // This is the route configuration as a parent
        $collection->clear();
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
        $datagridMapper
            ->add('email', null, [
                'label' => "Email",
                'advanced_filter' => false
            ])
            ->add('enabled', null, array(
                'label' => 'Activé ?',
                'advanced_filter' => false
            ))
        ;
    }

    /**
    * {@inheritdoc}
    */
    // protected function configureRoutes(RouteCollection $collection)
    // {
    //     // $collection->remove('create');
    //     // if (!$this->isGranted('ROLE_SUPER_ADMIN')) {
    //     //     $collection->clearExcept([]);
    //     // }
    //     if ($this->isChild()) {
    //         return;
    //     }

    //     // This is the route configuration as a parent
    //     // $collection->clear();
    // }
}
