<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use App\Entity\User;
use App\Entity\Flux;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType as SChoiceType;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * Administration des Flux
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class FluxAdmin extends AbstractAdmin
{
    protected $translator;
    protected $security;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setTranslator(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $query = $this->getModelManager()->createQuery(Flux::class);
        foreach ($this->extensions as $extension) {
            $extension->configureQuery($this, $query, $context);
        }
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->clearExcept(array('list', 'export'));
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('transfert_or_transaction', 'doctrine_orm_callback', array(
                'label' => "Type",
                'callback' => function ($queryBuilder, $alias, $field, $value) {
                    if (!$value['value']) {
                        return;
                    }
                    $queryBuilder
                        ->where($alias.".parenttype = :type")
                        ->setParameter('type', $value['value']);
                    return true;
                },
                'advanced_filter' => false,
                'show_filter' => true,
                'field_type' => SChoiceType::class,
                'field_options' => array(
                    'choices' => array('Transactions' => 'transaction', 'Transferts' => 'transfert', 'Cotisations' => 'cotisation', 'Achat de monnaie' => 'achat'),
                    'placeholder' => 'Indifférent',
                    'expanded' => true,
                    'multiple' => false
                )
            ))
            ->add('type', null, array(
                'label' => 'Type plus précis',
                'advanced_filter' => false,
                'show_filter' => true
            ))
            ->add('operateur', null, array(
                'label' => 'Operateur',
                'advanced_filter' => false,
                'show_filter' => true
            ))
        ;
    }

    public function getTemplate($name)
    {
        if ($name == 'list') {
            return 'block/base_list_with_total.html.twig';
        }

        return parent::getTemplate($name);
    }

    public function getTotalLabel()
    {
        return $this->translator->trans('Total des flux :');
    }

    public function getTotal()
    {
        $datagrid = $this->getDatagrid();
        $datagrid->buildPager();

        $query = clone $datagrid->getQuery();
        $query
            ->select('SUM( ' . $query->getRootAlias() . '.montant) as total')
            ->setFirstResult(null)
            ->setMaxResults(null);

        $result = $query->execute(array(), \Doctrine\ORM\Query::HYDRATE_SINGLE_SCALAR);

        return $result;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->add('createdAt', 'datetime', array('label' => 'Date'))
            ->add('type', null, array('label' => 'Type'))
            ->add('montant', null, array('label' => 'Montant'))
            ->add('expediteur', null, array('label' => 'Expediteur'))
            ->add('destinataire', null, array('label' => 'Destinataire'))
            ->add('operateur', null, array('label' => 'Operateur'))
            ->addIdentifier('reference', null, array('label' => 'Reference'))
            // @TODO : ajouter le verify uniquement si l'on souhaite (param url)=> sinon c'est beaucoup trop long...
            // ->addIdentifier('verify', null, array('label' => 'Vérifié'))
        ;
    }
	
	//Surcharge pour que tous les champs visibles à l'écran soient présent dans l'export
    public function getExportFields()
    {
        return [
            'IdFlux'               => 'id',
            'Date'                 => 'created_at',
            'Expéditeur'           => 'expediteur',
            'Destinataire'         => 'destinataire',
            'Opérateur'            => 'operateur',
            'Montant'              => 'montant',
            'Type de flux'         => 'type',
            'Moyen de paiement'    => 'moyen',
            'Réference'            => 'reference'
        ];
    }
}
