<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use App\Entity\User;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

/**
 * Administration des documents
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class DocumentAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'document';
    protected $baseRoutePattern = 'document';
    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $document = $this->getSubject();
        $formMapper
            ->add('user', HiddenType::class, array(
                'data' => $this->getConfigurationPool()->getContainer()->get('security.token_storage')->getToken()->getUser()->getId(),
                'data_class' => null,
                'entity_class' => User::class,
                'em' => $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager()
            ))
            ->add('media', MediaType::class, array(
                'provider' => 'sonata.media.provider.file',
                'context' => 'document',
                'label' => 'Document'
            ))
            ->add('name', TextType::class, array(
                'label' => 'Titre :'
            ))
            ->add('content', CKEditorType::class, array(
                'label' => 'Texte',
                'required' => false,
            ))
            ->add('enabled', CheckboxType::class, array(
                'label' => 'Activé ?',
                'required' => false,
                'label_attr' => array('class' => 'checkbox-inline')
            ))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array('label' => 'Titre'))
            ->addIdentifier('content', 'html', array('truncate' => array('length' => 80), 'label' => 'Description'))
            ->addIdentifier('media', null, array('label' => 'Fichier'))
            ->add('enabled', null, array(
                'label' => 'Activé',
                'editable' => true
            ))
        ;
    }
}
