<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Import;
use App\Entity\User;
use App\Enum\ImportEnum;
use Doctrine\ORM\EntityManagerInterface;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class ImportFormType extends AbstractType
{
    protected $em;
    protected $security;

    public function __construct(EntityManagerInterface $em, Security $security)
    {
        $this->em = $em;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if (empty($this->security) || empty($this->security->getUser())) {
            throw new \Exception("Opération impossible ! Utilisateur non connecté !");
        }
        $builder
            ->add('media', MediaType::class, array(
                'provider' => 'sonata.media.provider.file',
                'context' => 'import',
                'label' => 'Fichier .csv',
                'show_unlink' => false,
                'required' => true,
            ))
            ->add('user', HiddenType::class, array(
                'data_class' => null,
                'data' => $this->security->getUser()->getId(),
                'entity_class' => User::class,
                'em' => $this->em
            ))
            ->add('type', ChoiceType::class, array(
                'label' => 'Choisir le type de données à importer : ',
                'placeholder' => '',
                'required' => true,
                'choices' => ImportEnum::getAvailableTypes(),
                'choice_label' => function ($choice) {
                    return ImportEnum::getTypeName($choice);
                },
            ))
            ->add('sendemail', CheckboxType::class, array(
                'label' => 'Envoyé un email aux nouveaux comptes créés ?',
                'required' => false,
                'label_attr' => array('class' => 'checkbox-inline')
            ))
            ->add('save', SubmitType::class, ['label' => "Importer les données"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Import::class,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formImport';
    }
}
