<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Enum;

abstract class ImportEnum
{
    const IMPORT_GROUPE          = "groupe";
    const IMPORT_COMPTOIR        = "comptoir";
    const IMPORT_PRESTATAIRE     = "prestataire";
    const IMPORT_ADHERENT        = "adherent";

    /** @var array user friendly named type */
    protected static $typeName = [
        self::IMPORT_GROUPE        => 'Groupe(s)',
        self::IMPORT_COMPTOIR      => 'Comptoir(s)',
        self::IMPORT_PRESTATAIRE   => 'Prestataire(s)',
        self::IMPORT_ADHERENT      => 'Adherent(s)',
    ];

    /**
     * @param  string $typeShortName
     * @return string
     */
    public static function getTypeName($typeShortName)
    {
        if (!isset(static::$typeName[$typeShortName])) {
            return "Unknown type ($typeShortName)";
        }

        return static::$typeName[$typeShortName];
    }

    /**
     * @return array<string>
     */
    public static function getAvailableTypes()
    {
        return [
            self::IMPORT_GROUPE,
            self::IMPORT_COMPTOIR,
            self::IMPORT_PRESTATAIRE,
            self::IMPORT_ADHERENT
        ];
    }
}
