<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * @ORM\Entity(repositoryClass="App\Repository\GlobalParameterRepository")
 * @UniqueEntity(
 *     fields={"name"},
 *     errorPath="name",
 *     message="Ce nom de paramètre est déjà utilisé !"
 * )
 */
class GlobalParameter
{
    // Default global parameters for MLC
    const USE_WORDPRESS             = 'USE_WORDPRESS';
    const MLC_NAME                  = 'MLC_NAME';
    const MLC_NAME_SMALL            = 'MLC_NAME_SMALL';
    const MLC_NOTIF_EMAIL           = 'MLC_NOTIF_EMAIL';
    const MLC_CONTACT_EMAIL         = 'MLC_CONTACT_EMAIL';
    const COTISATION_ADHERENT       = 'COTISATION_ADHERENT';
    const COTISATION_PRESTATAIRE    = 'COTISATION_PRESTATAIRE';
    const RECONVERSION_PRESTATAIRE  = 'RECONVERSION_PRESTATAIRE';
    const MAP_CENTER                = 'MAP_CENTER';
    const MAP_ZOOM                  = 'MAP_ZOOM';
    const USE_PAYZEN                = 'USE_PAYZEN';
    const APP_TITLE                 = 'APP_TITLE';
    const WORDPRESS_URL             = 'WORDPRESS_URL';

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $name;

    /**
     * @ORM\Column(type="text")
     */
    private $value;

    /**
     * @ORM\Column(type="boolean")
     */
    private $mandatory;

    public function __toString()
    {
        return $this->getName(). ' => '.$this->getValue();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(string $value): self
    {
        $this->value = $value;

        return $this;
    }

    /**
    * Get mandatory
    * @return
    */
    public function getMandatory()
    {
        return $this->mandatory;
    }

    /**
    * Set mandatory
    * @return $this
    */
    public function setMandatory($mandatory)
    {
        $this->mandatory = $mandatory;
        return $this;
    }
}
