<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use ApiPlatform\Core\Annotation\ApiResource;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ORM\Entity
 * @ORM\Table(name="geoloc")
 */
class Geoloc
{
    use EnablableEntityTrait;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(name="id", type="integer")
     * @ORM\GeneratedValue
     * @Groups({"read"})
     */
    protected $id;

    /**
     * @var null|string
     *
     * @ORM\Column(name="adresse", type="string", length=255, nullable=true)
     * @Groups({"read", "write"})
    */
    private $adresse;

    /**
     * @var null|int
     *
     * @ORM\Column(name="cpostal", type="string", length=10, nullable=true)
     * @Groups({"read", "write"})
     */
    private $cpostal;

    /**
     * @var null|string
     *
     * @ORM\Column(name="ville", type="string", length=100, nullable=true)
     * @Groups({"read", "write"})
     */
    private $ville;

    /**
     * @var null|float
     *
     * @ORM\Column(name="lat", type="decimal", precision=10, scale=8, nullable=true)
     * @Groups({"read", "write"})
     */
    private $lat;

    /**
     * @var null|float
     *
     * @ORM\Column(name="lon", type="decimal", precision=10, scale=8, nullable=true)
     * @Groups({"read", "write"})
     */
    private $lon;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return null|string
     */
    public function getAdresse(): ?string
    {
        return $this->adresse;
    }

    /**
     * @param null|string $adresse
     * @return Geoloc
     */
    public function setAdresse(?string $adresse)
    {
        $this->adresse = $adresse;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCpostal(): ?string
    {
        return $this->cpostal;
    }

    /**
     * @param string|null $cpostal
     * @return Geoloc
     */
    public function setCpostal(?string $cpostal)
    {
        $this->cpostal = $cpostal;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getVille(): ?string
    {
        return $this->ville;
    }

    /**
     * @param null|string $ville
     * @return Geoloc
     */
    public function setVille(?string $ville)
    {
        $this->ville = $ville;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getLat(): ?float
    {
        return $this->lat;
    }

    /**
     * @param float|null $lat
     * @return Geoloc
     */
    public function setLat(?float $lat)
    {
        $this->lat = $lat;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getLon(): ?float
    {
        return $this->lon;
    }

    /**
     * @param float|null $lon
     * @return Geoloc
     */
    public function setLon(?float $lon)
    {
        $this->lon = $lon;
        return $this;
    }

    public function __toString(): string
    {
        return (!empty($this->adresse)?$this->adresse:'').' '.(!empty($this->cpostal)?$this->cpostal:'').' '.(!empty($this->ville)?$this->ville:'');
    }
}
