<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity\EntityTrait;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Serializer\Annotation\Groups;

trait NameSlugContentEntityTrait
{
    /**
     * @var string|null
     *
     * @ORM\Column(length=150)
     * @Assert\NotBlank
     * @Assert\Length(max=150)
     * @Groups({"read", "write"})
     */
    protected $name;

    /**
     * @var string|null
     *
     * @Gedmo\Slug(fields={"name"})
     * @ORM\Column(length=150, unique=true)
     * @Groups({"read"})
     */
    protected $slug;

    /**
     * @var string|null
     *
     * @ORM\Column(type="text", nullable=true)
     * @Groups({"read", "write"})
     */
    private $content;

    public function getContent(): ?string
    {
        return $this->content;
    }

    public function setDescription(?string $content)
    {
        $this->setContent($content);
        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->getContent();
    }

    public function setContent(?string $content)
    {
        $this->content = $content;
        return $this;
    }

    public function __toString(): string
    {
        return $this->name;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name)
    {
        $this->name = $name;
        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->getName();
    }

    public function setTitle(?string $name)
    {
        $this->setName($name);
        return $this;
    }

    public function getSlug(): ?string
    {
        return $this->slug;
    }

    public function setSlug(?string $slug)
    {
        $this->slug = $slug;
        return $this;
    }
}
