<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Entity\Prestataire;
use App\Entity\CotisationInfos;
use App\Enum\MoyenEnum;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Cotisation d'un utilisateur
 *
 * @ORM\Entity
 */
class Cotisation extends Flux
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_dest_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @ORM\OneToOne(targetEntity="CotisationInfos", inversedBy="cotisation", cascade={"persist"})
     * @ORM\JoinColumn(name="cotisationinfos_id", referencedColumnName="id", nullable=true)
     */
    protected $cotisationInfos;

    /**
     * Constructeur
     */
    public function __construct()
    {
        parent::__construct();
        $this->cotisationInfos = new CotisationInfos();
    }

    public function operate($em)
    {
        // Récupérer l'unique Prestataire/Association qui reçoit les cotisations !
        // $destinataires = $em->getRepository(Prestataire::class)->findBy(array('mlc' => true));
        // if (count($destinataires) > 1 || count($destinataires) <= 0) {
        //     throw new \Exception("[FLUX] Opération impossible ! Prestataire recevant la monnaie locale non configuré !");
        // }
        // $destinataire = $destinataires[0];
        if ($this->getMoyen() == MoyenEnum::MOYEN_MLC) {
            $compteExp = $this->getExpediteur()->getEcompte() - $this->getMontant();
            if ($compteExp < 0) {
                throw new \Exception("[FLUX] Opération impossible ! Montant supérieur au solde de monnaie éléctronique !");
            } else {
                $this->getExpediteur()->removeEcompte($this->getMontant());
                $this->getDestinataire()->addEcompte($this->getMontant());

                return [$this->getExpediteur(), $this->getDestinataire()];
            }
        }
        // Pas d'opération si la cotisation se fait par CB
        return [];
    }

    public function getUsersToNotify()
    {
        return ['siege'];
    }

    /**
     * @return string
     */
    public function getParenttype(): string
    {
        return self::TYPE_COTISATION;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'cotisation';
    }

    /**
    * Get cotisationInfos
    * @return cotisationInfos
    */
    public function getCotisationInfos(): ?CotisationInfos
    {
        return $this->cotisationInfos;
    }

    /**
    * Set CotisationInfos cotisationInfos
    * @return $this
    */
    public function setCotisationInfos(CotisationInfos $cotisationInfos)
    {
        $this->cotisationInfos = $cotisationInfos;
        return $this;
    }

    /**
     * @return int
     */
    public function getAnnee(): ?int
    {
        return $this->cotisationInfos->getAnnee();
    }

    /**
     * @param int $annee
     * @return Cotisation
     */
    public function setAnnee(int $annee)
    {
        $this->cotisationInfos->setAnnee($annee);
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDebut(): ?\DateTime
    {
        return $this->cotisationInfos->getDebut();
    }

    /**
     * @param \DateTime $debut
     * @return Cotisation
     */
    public function setDebut(\DateTime $debut)
    {
        $this->cotisationInfos->setDebut($debut);
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getFin(): ?\DateTime
    {
        return $this->cotisationInfos->getFin();
    }

    /**
     * @param \DateTime $fin
     * @return Cotisation
     */
    public function setFin(\DateTime $fin)
    {
        $this->cotisationInfos->setFin($fin);
        return $this;
    }

    /**
     * @return bool
     */
    public function isRecu(): ?bool
    {
        return $this->cotisationInfos->isRecu();
    }

    /**
     * @param bool $recu
     * @return Cotisation
     */
    public function setRecu(bool $recu)
    {
        $this->cotisationInfos->setRecu($recu);
        return $this;
    }
}
