<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use App\Entity\Adherent;
use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSACTION
 *  - Achat de monnaie en CB par un Adhérent
 *
 * @ORM\Entity
 */
class AchatMonnaieAdherent extends AchatMonnaie
{
  /**
   * @ORM\ManyToOne(targetEntity="Adherent")
   * @ORM\JoinColumn(name="adherent_dest_id", referencedColumnName="id", nullable=true)
   */
  protected $destinataire;

  /**
   * @return string
   */
  public function getType(): string
  {
      return 'achat_monnaie_adherent';
  }
}
