<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\Groupe;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransfertPrestataireComptoir;
use App\Entity\Usergroup;
use App\Entity\VenteComptoirAdherent;
use App\Entity\VenteComptoirPrestataire;
use App\Entity\RetraitComptoirAdherent;
use App\Entity\RetraitComptoirPrestataire;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\GroupeInfosFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransfertPrestataireComptoirFormType;
use App\Form\Type\VenteComptoirAdherentFormType;
use App\Form\Type\VenteComptoirPrestataireFormType;
use App\Form\Type\RetraitComptoirAdherentFormType;
use App\Form\Type\RetraitComptoirPrestataireFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserComptoirController extends FluxController
{
    /**
     * @Route("/user/comptoir/infos", name="comptoir_infos")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function groupeInfosAction(Request $request)
    {
        $form = $this->createForm(ComptoirInfosFormType::class, $this->session->get('_comptoirgere'));
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Comptoir bien modifié !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->redirectToRoute('index');
    }

    // /**
    //  * @Route("/user/comptoir/transfert/adherent/", name="transfertComptoirAdherent")
    //  * @IsGranted("ROLE_COMPTOIR")
    //  */
    // public function transfertComptoirAdherentAction(Request $request)
    // {
    //     $entity = new TransfertComptoirAdherent();
    //     $entity->setOperateur($this->getUser());
    //     $form = $this->createForm(TransfertComptoirAdherentFormType::class, $entity);
    //     return $this->manageFluxForm(
    //         $request,
    //         $form,
    //         $this->session->get('_comptoirgere')->getCompte(),
    //         $this->translator->trans('Transfert à un adhérent bien effectuée !'),
    //         $this->translator->trans('Transfert à un adhérent')
    //     );
    // }

    // /**
    //  * @Route("/user/comptoir/transfert/prestataire/", name="transfertComptoirPrestataire")
    //  * @IsGranted("ROLE_COMPTOIR")
    //  */
    // public function transfertComptoirPrestataireAction(Request $request)
    // {
    //     $entity = new TransfertComptoirPrestataire();
    //     $entity->setOperateur($this->getUser());
    //     $form = $this->createForm(TransfertComptoirPrestataireFormType::class, $entity);
    //     return $this->manageFluxForm(
    //         $request,
    //         $form,
    //         $this->session->get('_comptoirgere')->getCompte(),
    //         $this->translator->trans('Transfert à un prestataire bien effectuée !'),
    //         $this->translator->trans('Transfert à un prestataire')
    //     );
    // }

    /**
     * @Route("/user/comptoir/vente/adherent/", name="venteComptoirAdherent")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function venteComptoirAdherentAction(Request $request)
    {
        $entity = new VenteComptoirAdherent();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(VenteComptoirAdherentFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_comptoirgere')->getCompte(),
            $this->translator->trans('Vente à un adhérent bien effectuée !'),
            $this->translator->trans('Vente à un adhérent')
        );
    }

    /**
     * @Route("/user/comptoir/vente/prestataire/", name="venteComptoirPrestataire")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function venteComptoirPrestataireAction(Request $request)
    {
        $entity = new VenteComptoirPrestataire();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(VenteComptoirPrestataireFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_comptoirgere')->getCompte(),
            $this->translator->trans('Vente à un prestataire bien effectuée !'),
            $this->translator->trans('Vente à un prestataire')
        );
    }

    /**
     * @Route("/user/comptoir/retrait/adherent/", name="retraitComptoirAdherent")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function retraitComptoirAdherentAction(Request $request)
    {
        $entity = new RetraitComptoirAdherent();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(RetraitComptoirAdherentFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_comptoirgere')->getCompte(),
            $this->translator->trans("Retrait d'un adhérent bien effectuée !"),
            $this->translator->trans("Retrait d'un adhérent")
        );
    }

    /**
     * @Route("/user/comptoir/retrait/prestataire/", name="retraitComptoirPrestataire")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function retraitComptoirPrestataireAction(Request $request)
    {
        $entity = new RetraitComptoirPrestataire();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(RetraitComptoirPrestataireFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_comptoirgere')->getCompte(),
            $this->translator->trans("Retrait d'un prestataire bien effectuée !"),
            $this->translator->trans("Retrait d'un prestataire")
        );
    }

    /**
     * @Route("/user/comptoir/reconversion/", name="transfertPrestataireComptoir")
     * @IsGranted("ROLE_COMPTOIR")
     */
    public function transfertPrestataireComptoirAction(Request $request)
    {
        $entity = new TransfertPrestataireComptoir();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertPrestataireComptoirFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_comptoirgere')->getCompte(),
            $this->translator->trans('Reconversion bien effectuée !'),
            $this->translator->trans("Reconversion d'un prestataire")
        );
    }
}
