<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\TransactionAdherentAdherent;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\AchatMonnaieAdherent;
use App\Entity\Payment;
use App\Entity\Usergroup;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\TransactionAdherentAdherentFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\AchatMonnaieAdherentFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserAdherentController extends FluxController
{
    /**
      * @Route("/adherent/infos", name="adherent_infos")
      * @IsGranted("ROLE_ADHERENT")
      */
    public function adherentInfosAction(Request $request)
    {
        $form = $this->createForm(AdherentInfosFormType::class, $this->getUser()->getAdherent());
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->em->persist($form->getData());
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Infos de l\'adhérent modifiées !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->redirectToRoute('index');
    }

    /**
     * @Route("/adherent/transaction/prestataire/", name="transactionAdherentPrestataire")
     * @IsGranted("ROLE_ADHERENT")
     */
    public function transactionAdherentPrestataireAction(Request $request)
    {
        $entity = new TransactionAdherentPrestataire();
        $entity->setOperateur($this->getUser());
        $entity->setExpediteur($this->getUser()->getAdherent());
        $form = $this->createForm(TransactionAdherentPrestataireFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->getUser()->getAdherent()->getCompte(),
            $this->translator->trans('Transaction à un prestataire bien effectuée !'),
            $this->translator->trans('Transaction à un prestataire')
        );
    }

    /**
     * @Route("/adherent/transaction/adherent/", name="transactionAdherentAdherent")
     * @IsGranted("ROLE_ADHERENT")
     */
    public function transactionAdherentAdherentAction(Request $request)
    {
        if (empty($this->getUser()) || empty($this->getUser()->getAdherent())) {
            return $this->redirectToRoute('index');
        }
        $entity = new TransactionAdherentAdherent();
        $entity->setOperateur($this->getUser());
        $entity->setExpediteur($this->getUser()->getAdherent());
        $form = $this->createForm(TransactionAdherentAdherentFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->getUser()->getAdherent()->getCompte(),
            $this->translator->trans('Transaction à un adhérent bien effectuée !'),
            $this->translator->trans('Transaction à un adhérent')
        );
    }

    /**
     * @Route("/adherent/achat-monnaie/", name="achatMonnaieAdherent")
     * @IsGranted("ROLE_ADHERENT")
     */
    public function achatMonnaieAdherentAction(Request $request)
    {
        if (empty($this->getUser()) || empty($this->getUser()->getAdherent())) {
            return $this->redirectToRoute('index');
        }

        $entity = new AchatMonnaieAdherent();
        $form = $this->createForm(AchatMonnaieAdherentFormType::class, $entity);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
          return $this->preparePaymentAction(
            $form,
            Payment::TYPE_ACHAT_MONNAIE_ADHERENT
          );
        }

        return $this->render('flux/transaction.html.twig', [
            'form' => $form->createView(),
            'title' => $this->translator->trans('Achat de monnaie locale')
        ]);
    }
}
