<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * Import de données
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class ImportAdmin extends AbstractAdmin
{
    protected $baseRoutePattern = 'importdata';
    protected $baseRouteName = 'importdata';
    protected $datagridValues = [
        // reverse order (default = 'ASC')
        '_sort_order' => 'DESC',
        // name of the ordered field (default = the model's id field, if any)
        '_sort_by' => 'createdAt',
        // '_page' => 1,
        // '_per_page' => 32
    ];

    /**
    * {@inheritdoc}
    */
    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->clearExcept(array('list', 'create', 'show'));
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        $query
            ->innerJoin($query->getRootAliases()[0] .'.user', 'u')
            ->addSelect('u')
        ;
        return $query;
    }

    public function configureActionButtons($action, $object = null)
    {
        $list = parent::configureActionButtons($action, $object);

        $list['create']['template'] = '@SonataAdmin/CRUD/import_button.html.twig';
        // $list['show']['template'] = '@SonataAdmin/CRUD/import_button.html.twig';

        return $list;
    }

    protected function configureListFields(ListMapper $listMapper): void
    {
        parent::configureListFields($listMapper);
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('createdAt', 'datetime', ['label' => 'Date'])
            ->add('user', null, ['label' => 'Utilisateur'])
            ->addIdentifier('type')
            ->add('nbentityadded', null, ['label' => 'Lignes correctes'])
            ->add('nbentityerror', null, ['label' => 'Lignes en erreurs'])
            ->add('media', null, ['label' => 'Fichier'])
            ->add('_action', null, [
                'actions' => [
                    'show' => [],
                ]
            ])
        ;
    }

    protected function configureShowFields(ShowMapper $showMapper): void
    {
        $object = $showMapper->getAdmin()->getSubject();
        $showMapper
            ->with('Import')
                ->add('createdAt')
                ->add('user')
                ->add('type')
                ->add('media')
                ->add('nbentityadded', null, ['label' => 'Lignes correctes'])
                ->add('nbentityerror', null, ['label' => 'Lignes en erreurs'])
            ->end();
        if (!empty(json_decode($object->getSuccess()))) {
            $showMapper
                ->with('Correct', [
                        'box_class'   => 'box box-solid box-success',
                        // 'description' => 'Lorem ipsum',
                    ])
                    ->add('success', 'json', ['label' => false])
                ->end()
            ;
        }
        if (!empty(json_decode($object->getWarnings()))) {
            $showMapper
                ->with('Warnings', [
                    'box_class'   => 'box box-solid box-warning',
                    // 'description' => 'Lorem ipsum',
                ])
                ->add('warnings', 'json', ['label' => false])
                ->end()
                ;
        }
        if (!empty(json_decode($object->getErrors()))) {
            $showMapper
                ->with('Erreurs', [
                        'box_class'   => 'box box-solid box-danger',
                        // 'description' => 'Lorem ipsum',
                    ])
                    ->add('errors', 'json', ['label' => false])
                ->end()
            ;
        }
        ;
    }

    public function getBatchActions()
    {
        $actions = parent::getBatchActions();
        unset($actions['delete']);

        return $actions;
    }
}
