/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

require('../leaflet/leaflet.js');
require('../js/flash-messages.js');

$(document).ready(function() {
	var mapMarkers = [];
	$(document).on('click', '.searchLatLon', function (e) {
		e.preventDefault();
	    var self = $(this);
	    $.ajax({
	        url : self.data('url'),
	        type: 'post',
	        data : {'adresse' : $('#'+(self.attr('id').replace('_geoloc_search', ''))+'_geoloc_adresse').val(), 'cpostal' : $('#'+(self.attr('id').replace('_geoloc_search', ''))+'_geoloc_cpostal').val(), 'ville' : $('#'+(self.attr('id').replace('_geoloc_search', ''))+'_geoloc_ville').val()},
	        success: function(response) {
	        	var divid = self.attr('id').replace('_geoloc_search', '');
	        	$('#'+divid+'_message').remove();
	        	$('#'+divid+'_map').remove();
	        	var marker_1 = null;
	            if(response.status == 'success' && response.data && response.data.lat != '' && response.data.lon != '') {
	            	$('#'+divid+'_geoloc_lat').val(response.data.lat);
	            	$('#'+divid+'_geoloc_lon').val(response.data.lon);
	                $('#'+divid+'_geoloc_lat').addClass('inputsuccess');
	                $('#'+divid+'_geoloc_lon').addClass('inputsuccess');
	                $('<p id="'+(divid+'_message')+'">Cliquez sur la carte si vous voulez affiner la géolocalisation</p><div id="'+(divid+'_map')+'" style="height: 250px;margin-top: 10px;"></div>').insertAfter('#'+self.attr('id'));
	                var latlon = L.latLng(parseFloat(response.data.lat), parseFloat(response.data.lon));
	                var mymap = L.map(divid+'_map').setView(latlon, 13);
					L.tileLayer('https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png', {maxZoom: 18, attribution: '&copy; Openstreetmap France | &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'}).addTo(mymap);
					var marker_1 = L.marker(latlon).addTo(mymap);
	            } else {
	                $(this).addClass('inputerror');
	                $('<p id="'+(divid+'_message')+'">ADRESSE INCONNUE : Cliquez sur la carte pour définir une adresse</p><div id="'+(divid+'_map')+'" style="height: 250px;margin-top: 10px;"></div>').insertAfter('#'+self.attr('id'));
	                var mymap = L.map(divid+'_map').setView(JSON.parse($('#koh_map_center').val()), parseInt($('#koh_map_zoom').val()));
	                L.tileLayer('https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png', {maxZoom: 18, attribution: '&copy; Openstreetmap France | &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'}).addTo(mymap);
				}
				mymap.on('click', function(e){
					if (marker_1 != null) {
						mymap.removeLayer(marker_1);
					}
					for(var i = 0; i < mapMarkers.length; i++){
					    mymap.removeLayer(mapMarkers[i]);
					}
				    // Add marker to map at click location; add popup window
				    var newMarker = new L.marker(e.latlng);
				    newMarker.addTo(mymap);
				    mapMarkers.push(newMarker);
				    $('#'+divid+'_geoloc_lat').val(e.latlng.lat);
				    $('#'+divid+'_geoloc_lon').val(e.latlng.lng);
				    $('#'+divid+'_geoloc_lat').addClass('inputsuccess');
				    $('#'+divid+'_geoloc_lon').addClass('inputsuccess');
				});
	        }
	    });
	});
});
